import QtQuick 2.3
import "../" // to import RocketScene
import "../_SharedQML"
import AdaptDemoSystem 1.0

RocketScene { 
  FlyCamera { }
  Group { 
    //setup default textures
    TextureImage { textureUnit: 1; file: "../../images/_SK57414_normal.png"}
    TextureImage { textureUnit: 2; file: "../../images/area_lights.jpg"}
    Texture { textureUnit: 3; textureRT: "prev" }
    Texture { textureUnit: 4; textureRT: "prevBlur" }
    Texture { textureUnit: 5; textureRT: "prevNormal" }
  }
  Group { 
    // big mirror plane
    Shader { file: "smInfi" }
    TextureImage { textureUnit: 0; file: "../../images/aalto.png"}
    DrawMesh { 
      file: "mesh/box1m.lwo"; enabled: true; smoothNormals: true; normalSmoothAngle: 20; blendMode: "off"; depthTest: true; depthWrite: true; cull: false; cullBack: false; Pos { x: 0.0; y: -1.40; z: 0.0}
      Rot { d: 0; ax: 1.0; ay: 0.0; az: 0.0 }
      Sca { s: 10.0; x: 100.0; y: 1.0; z: 100.0 }
      ShaderParam { paramName: "g_uvScale"; paramValue: 3.0}
      ShaderParam { paramName: "g_texBrightness"; paramValue: 0.40}
      ShaderParam { paramName: "g_texAmbient"; paramValue: 0.0}
      ShaderParam { paramName: "g_bump"; paramValue: 1.50}
      ShaderParam { paramName: "g_prevAmount"; paramValue: 0.0 }
      ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync("prevBlurAmount")}
      ShaderParam { paramName: "g_color"; paramValueVec4: "1.0, 1.0, 1.10, 1.0"}
      ShaderParam { paramName: "g_bright"; paramValue: 1.0}
      ShaderParam { paramName: "g_zoomTime"; paramValue: 0.0 }
    }
  }
  SurfNet { surfPotShader: "surfPot"; surfGeomShader: "surfGeom"; surfGridDim3DSqrt: 10; textureFile: "../../images/aalto.png"}
  Group { 
    // mirror ball
    enabled: true; Shader { file: "smPlastic" }
    TextureImage { textureUnit: 0; file: "../../images/meteor.png"}
    DrawMesh { 
      file: "mesh/ball5000.x"; enabled: true; smoothNormals: true; normalSmoothAngle: 20; blendMode: "off"; depthTest: true; depthWrite: true; Pos { x: 0.0; y: 4.0; z: 0.0}
      Rot { d: -90; ax: 1.0; ay: 0.0; az: 0.0 }
      Sca { s: 32.0; x: 1.0; y: 1.0; z: 1.0 }
      ShaderParam { paramName: "g_uvScale"; paramValue: 4.0}
      ShaderParam { paramName: "g_bump"; paramValue: 0.50}
      ShaderParam { paramName: "g_texBrightness"; paramValue: 0.025 }
      ShaderParam { paramName: "g_texAmbient"; paramValue: 0.00 }
      ShaderParam { paramName: "g_prevAmount"; paramValue: 0.0 }
      ShaderParam { paramName: "g_prevBlurAmount"; paramValue: sync("prevBlurAmount") }
      ShaderParam { paramName: "g_color"; paramValueVec4: "1.0, 1.0, 1.0, 1.0"}
      ShaderParam { paramName: "g_bright"; paramValue: 1.0}
    }
  }
  Blit { textureRT: "depth"; blitRT: 1}
  PrevBlur { }
  // postprocs
  Tonemap { }
  Reflect { }
  Glow { }
  GodRay { }
  Blit { textureRT: "prev" }
  Vignette { }
  Coords { }
}
